/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _MEMTRANS_H_
#define	_MEMTRANS_H_

#include <linux/config.h>  
#include <scc/ucd_memmap_model.h>

#define	MEM_CHECK_ARG


#define DDR_ALL_START    0x80000000
#define DDR_ALL_SIZE     (DDR_CH0_SIZE+DDR_CH1_SIZE)
#define DDR_CH0_START    0x80000000
#define DDR_CH0_MAPSTART 0x40000000
#define DDR_CH0_MAPSIZE  0x10000000
#define DDR_CH0_MASK     (DDR_CH0_SIZE-1)
#define DDR_CH1_START    0xc0000000
#define DDR_CH1_MAPSTART 0x60000000
#define DDR_CH1_MAPSIZE  0x10000000
#define DDR_CH1_MASK     (DDR_CH1_SIZE-1)
#define DDR_CH0_OFFSET   0x00000000
#define DDR_CH1_OFFSET   0x40000000


#if 0 
#if DDR_CH0_START+DDR_CH0_SIZE != DDR_CH1_START
# error DDR_CH0 and DDR_CH1 is discontinuous !!
#endif
#if DDR_CH0_SIZE+DDR_CH1_SIZE != DDR_ALL_SIZE
# error DDR_ALL_SIZE is not sum of DDR_CH0_SIZE and DDR_CH1_SIZE !!
#endif
#if DDR_CH0_MASK != (DDR_CH0_SIZE-1)
# error mask and/or size of DDR_CH0 contradict! contra dextra avenue !!
#endif
#if DDR_CH1_MASK != (DDR_CH1_SIZE-1)
# error mask and/or size of DDR_CH1 contradict! contra dextra avenue !!
#endif
#if DDR_CH0_MAPSTART+DDR_CH0_MAPSIZE != DDR_CH1_MAPSTART
# error DDR_CH0_MAP and DDR_CH1_MAP is discontinuous !!
#endif
#else 
#endif 

#if defined(_BOOT_MINI) || defined(PIE_STYLE_LINUX)
#define	MEM_PRINTF			CSC_printf
#elif defined(__KERNEL__)
#include <linux/kernel.h> 
#define	MEM_PRINTF			printk
#else
#include <stdio.h>
#define	MEM_PRINTF			printf
#endif

#ifdef MEM_CHECK_ARG
#define	MEM_BUG(offset, file, line)					\
        MEM_PRINTF("memtrans(%s): ERR: "				\
                   "illegal access to 0x%08x in %s:%d\n",		\
                   __func__, offset, file, line)
#else 
#define MEM_BUG(...)
#endif

#define	DDR_PHYADDR_KERN(x)						\
        DDR_phyaddr_kern((unsigned int) (x), __FILE__, __LINE__)
        
static inline unsigned int
DDR_phyaddr_kern(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#if 0 
        if (offset < DDR_CH0_SIZE) {                        
                addr = offset + DDR_ALL_START;
        } else if (offset < (DDR_CH0_SIZE+DDR_CH1_SIZE)) { 
                addr = offset + DDR_ALL_START;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        if ((offset < (  DDR_CH0_SIZE))) {                        
                addr = offset + DDR_ALL_START;
        } else if ((DDR_CH1_OFFSET <= offset) && (offset < (DDR_CH1_OFFSET+DDR_CH1_SIZE))) { 
                addr = offset + DDR_ALL_START;
        } else {
                MEM_BUG(offset, file, line);
        }
#endif

        return addr;
}

#define	DDR_PHYADDR_USER(x)						\
        DDR_phyaddr_user((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_user(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#if 0 
        if (offset < DDR_CH0_SIZE) {                     
                addr = offset + DDR_ALL_START;
        } else if (offset < (DDR_CH0_SIZE+DDR_CH1_SIZE)) { 
                addr = offset + DDR_ALL_START;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        if ( (offset < ( DDR_CH0_SIZE))) {                        
                addr = offset + DDR_ALL_START;
        } else if ((DDR_CH1_OFFSET <= offset) && (offset < (DDR_CH1_OFFSET+DDR_CH1_SIZE))) { 
                addr = offset + DDR_ALL_START;
        } else {
                MEM_BUG(offset, file, line);
        }
#endif

        return addr;
}

#if 0 
#define	DDR_PHYADDR_KERN_CACHE(x)					\
        DDR_phyaddr_kern_cache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_kern_cache(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (offset < 0x20000000) {
                addr = offset + 0x80000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0x80000000;
#endif

        return addr;
}

#define	DDR_PHYADDR_KERN_UNCACHE(x)					\
        DDR_phyaddr_kern_uncache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_kern_uncache(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (offset < 0x20000000) {
                addr = offset + 0xA0000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0xA0000000;
#endif

        return addr;
}
#endif 

#define	DDR_PHYADDR_KERN_USER_SHARE(x)	DDR_PHYADDR_KERN(x)

#define	DDR_PHYMEMADDR(x)						\
        DDR_phymemaddr((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phymemaddr(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#if 0 
        if (offset < DDR_CH0_SIZE) {                      
                addr = offset + DDR_ALL_START;
        } else if (offset < (DDR_CH0_SIZE+DDR_CH1_SIZE)) { 
                addr = offset + DDR_ALL_START;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        if ( (offset < (  DDR_CH0_SIZE))) {                        
                addr = offset + DDR_ALL_START;
        } else if ((DDR_CH1_OFFSET <= offset) && (offset < (DDR_CH1_OFFSET+DDR_CH1_SIZE))) { 
                addr = offset + DDR_ALL_START;
        } else {
                MEM_BUG(offset, file, line);
        }
#endif

        return addr;
}

#define	DDR_CH(x)							\
        DDR_ch((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_ch(unsigned int offset, char *file, int line)
{
        unsigned int ch = 0;

#if 0 
        if (offset < DDR_CH0_SIZE) {                      
                ch = 0;
        } else if (offset < DDR_CH0_SIZE+DDR_CH1_SIZE) { 
                ch = 1;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        if ( (offset < (  DDR_CH0_SIZE))) {        
                ch = 0;
        } else if ((DDR_CH1_OFFSET <= offset) && (offset < (DDR_CH1_OFFSET+DDR_CH1_SIZE))) { 
                ch = 1;
        } else {
                MEM_BUG(offset, file, line);
        }
#endif
        return ch;
}

#define	DDR_CHOFFSET(x)							\
        DDR_choffset((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_choffset(unsigned int offset, char *file, int line)
{
        unsigned int ch_offset = 0;

#if 0 
        if (offset < DDR_CH0_SIZE) {                      
                ch_offset = offset & DDR_CH0_MASK;
        } else if (offset < DDR_CH0_SIZE+DDR_CH1_SIZE) { 
                ch_offset = offset & DDR_CH1_MASK;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        if ( (offset < (  DDR_CH0_SIZE))) {        
                ch_offset = offset & DDR_CH0_MASK;
        } else if ((DDR_CH1_OFFSET <= offset) && (offset < (DDR_CH1_OFFSET+DDR_CH1_SIZE))) { 
                ch_offset = offset & DDR_CH1_MASK;
        } else {
            MEM_BUG(offset, file, line);
        }
#endif

        return ch_offset;
}
#define	DDR_VADDR_UNCACHE(x)						\
        DDR_vaddr_uncache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_vaddr_uncache(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#if 0 
        if (offset < DDR_CH0_MAPSIZE) {            
                addr = offset + DDR_CH0_MAPSTART;
        } else if (offset < DDR_CH0_SIZE) {        
                MEM_BUG(offset, file, line);
        } else if (offset < DDR_CH0_SIZE+DDR_CH1_MAPSIZE) { 
                addr = offset - DDR_CH0_SIZE + DDR_CH1_MAPSTART;
        } else if (offset < DDR_CH0_SIZE+DDR_CH1_SIZE) {    
                MEM_BUG(offset, file, line);
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        if ( (offset < ( DDR_CH0_MAPSIZE))) {            
                addr = offset + DDR_CH0_MAPSTART;
        } else if ((DDR_CH1_OFFSET <= offset) && (offset < (DDR_CH1_OFFSET+DDR_CH1_MAPSIZE))) {    
                addr = offset - DDR_CH1_OFFSET + DDR_CH1_MAPSTART;
        } else {
            MEM_BUG(offset, file, line);                 
        }
#endif

        return addr;
}

#if 0 
#define	EXBUS_PHYADDR_USER(x)						\
        EXBUS_phyaddr_user((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
EXBUS_phyaddr_user(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (offset < 0x10000000) {
                addr = offset + 0x40000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0x40000000;
#endif

        return addr;
}

#define	EXBUS_PHYADDR_KERN_CACHE(x)					\
        EXBUS_phyaddr_kern_cache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
EXBUS_phyaddr_kern_cache(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (offset < 0x20000000) {
                addr = offset + 0x80000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0x80000000;
#endif

        return addr;
}

#define	EXBUS_PHYADDR_KERN_UNCACHE(x)					\
        EXBUS_phyaddr_kern_uncache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
EXBUS_phyaddr_kern_uncache(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (offset < 0x10000000) {
                addr = offset + 0xa0000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0xa0000000;
#endif

        return addr;
}

#define	EXBUS_VADDR_UNCACHE(x)						\
        EXBUS_vaddr_uncache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
EXBUS_vaddr_uncache(unsigned int offset, char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (offset < 0x10000000) {
                addr = offset + 0x40000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0x40000000;
#endif

        return addr;
}
#endif 

#define	DDR_PHYADDR_USER_TO_CHOFFSET(x)					\
        DDR_phyaddr_user_to_choffset((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_user_to_choffset(unsigned int addr, char *file, int line)
{
        unsigned int offset = 0;

#if 0 
        if (addr < DDR_CH0_START) {
                MEM_BUG(addr, file, line);
        } else if (addr < DDR_CH0_START+DDR_CH0_SIZE) { 
                offset = addr & DDR_CH0_MASK;
        } else if (addr < DDR_CH1_START+DDR_CH1_SIZE) { 
                offset = addr & DDR_CH1_MASK;
        } else {
                MEM_BUG(addr, file, line);
        }
#else
        if ((DDR_CH0_START <= addr) && (addr < (DDR_CH0_START+DDR_CH0_SIZE))) { 
                offset = addr & DDR_CH0_MASK;
        } else if ((DDR_CH1_START <= addr) && (addr < (DDR_CH1_START+DDR_CH1_SIZE))) { 
                offset = addr & DDR_CH1_MASK;
        } else {
            MEM_BUG(addr, file, line);
        }
#endif

        return offset;
}

#define	DDR_PHYADDR_TO_CHOFFSET(x)					\
        DDR_phyaddr_to_choffset((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_to_choffset(unsigned int addr, char *file, int line)
{
        unsigned int offset = 0;

#if 0 
        if (addr < DDR_CH0_START) {
                MEM_BUG(addr, file, line);
        } else if (addr < DDR_CH0_START+DDR_CH0_SIZE) { 
                offset = addr & DDR_CH0_MASK;
        } else if (addr < DDR_CH1_START+DDR_CH1_SIZE) { 
                offset = addr & DDR_CH1_MASK;
        } else {
                MEM_BUG(addr, file, line);
        }
#else
        if ((DDR_CH0_START <= addr) && (addr < (DDR_CH0_START+DDR_CH0_SIZE))) { 
                offset = addr & DDR_CH0_MASK;
        } else if ((DDR_CH1_START <= addr) && (addr < (DDR_CH1_START+DDR_CH1_SIZE))) { 
                offset = addr & DDR_CH1_MASK;
        } else {
            MEM_BUG(addr, file, line);
        }
#endif

        return offset;
}

#define	DDR_PHYADDR_USER_TO_CH(x)					\
        DDR_phyaddr_user_to_ch((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_user_to_ch(unsigned int addr, char *file, int line)
{
        unsigned int ch = 0;

#if 0 
        if (addr < DDR_CH0_START) {
                MEM_BUG(addr, file, line);
        } else if (addr < DDR_CH0_START+DDR_CH0_SIZE) { 
                ch = 0;
        } else if (addr < DDR_CH1_START+DDR_CH1_SIZE) { 
                ch = 1;
        } else {
                MEM_BUG(addr, file, line);
        }
#else
        if ((DDR_CH0_START <= addr) && (addr < (DDR_CH0_START+DDR_CH0_SIZE))) { 
                ch = 0;
        } else if ((DDR_CH1_START <= addr) && (addr < (DDR_CH1_START+DDR_CH1_SIZE))) { 
                ch = 1;
        } else {
            MEM_BUG(addr, file, line);
        }
#endif
        return ch;
}

#define	DDR_PHYADDR_TO_CH(x)						\
        DDR_phyaddr_to_ch((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_to_ch(unsigned int addr, char *file, int line)
{
        unsigned int ch = 0;

#if 0 
        if (addr < DDR_CH0_START) {
                MEM_BUG(addr, file, line);
        } else if (addr < DDR_CH0_START+DDR_CH0_SIZE) { 
                ch = 0;
        } else if (addr < DDR_CH1_START+DDR_CH1_SIZE) { 
                ch = 1;
        } else {
                MEM_BUG(addr, file, line);
        }
#else
        if ((DDR_CH0_START <= addr) && (addr < (DDR_CH0_START+DDR_CH0_SIZE))) { 
                ch = 0;
        } else if ((DDR_CH1_START <= addr) && (addr < (DDR_CH1_START+DDR_CH1_SIZE))) { 
                ch = 1;
        } else {
            MEM_BUG(addr, file, line);
        }
#endif

        return ch;
}

#define	DDR_CH_AND_OFFSET_TO_KERN_PHYADDR(x, y)				\
        DDR_ch_and_offset_to_kern_phymemaddr((unsigned int) (x),		\
                                             (unsigned int) (y),		\
                                             __FILE__, __LINE__)

static inline unsigned int
DDR_ch_and_offset_to_kern_phymemaddr(unsigned int ch, unsigned int offset,
                                char *file, int line)
{
        unsigned int addr = 0;

        if ((ch == 0) && (offset < DDR_CH0_SIZE)) {        
                addr = offset + DDR_CH0_START;
        } else if ((ch == 1) && (offset < DDR_CH1_SIZE)) { 
                addr = offset + DDR_CH1_START;
        } else {
                MEM_BUG(offset, file, line);
        }

        return addr;
}

#define	DDR_CH_AND_OFFSET_TO_PHYMEMADDR(x, y)	DDR_CH_AND_OFFSET_TO_KERN_PHYADDR(x, y)

#if 0  
#define	DDR_CH_AND_OFFSET_TO_PHYMEMADDR(x, y)				\
        DDR_ch_and_offset_to_phymemaddr((unsigned int) (x),		\
                                        (unsigned int) (y),		\
                                        __FILE__, __LINE__)

static inline unsigned int
DDR_ch_and_offset_to_phymemaddr(unsigned int ch, unsigned int offset,
                                char *file, int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (ch == 1 && offset < 0x20000000) {
                addr = offset + 0xA0000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0xA0000000;
#endif

        return addr;
}

#define	DDR_CH_AND_OFFSET_TO_KERN_CACHE_PHYADDR(x, y)			\
        DDR_ch_and_offset_to_kern_cache_phyaddr((unsigned int) (x),	\
                                                (unsigned int) (y),	\
                                                __FILE__, __LINE__)

static inline unsigned int
DDR_ch_and_offset_to_kern_cache_phyaddr(unsigned int ch,
                                        unsigned int offset, char *file,
                                        int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (ch == 1 && offset < 0x20000000) {
                addr = offset + 0x80000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0x80000000;
#endif

        return addr;
}


#define	DDR_CH_AND_OFFSET_TO_KERN_UNCACHE_PHYADDR(x, y)			\
        DDR_ch_and_offset_to_kern_uncache_phyaddr((unsigned int) (x),	\
                                                  (unsigned int) (y),	\
                                                  __FILE__, __LINE__)

static inline unsigned int
DDR_ch_and_offset_to_kern_uncache_phyaddr(unsigned int ch,
                                          unsigned int offset, char *file,
                                          int line)
{
        unsigned int addr = 0;

#ifdef MEM_CHECK_ARG
        if (ch == 1 && offset < 0x20000000) {
                addr = offset + 0xA0000000;
        } else {
                MEM_BUG(offset, file, line);
        }
#else
        addr = offset + 0xA0000000;
#endif

        return addr;
}

#define	DDR_CACHE_TO_UNCACHE(x)						\
        DDR_cache_to_uncache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_cache_to_uncache(unsigned int c_addr, char *file, int line)
{
#ifdef MEM_CHECK_ARG
        MEM_BUG(c_addr, file, line);
#endif
        return 0;
}

#define	DDR_UNCACHE_TO_CACHE(y)						\
        DDR_uncache_to_cache((unsigned int) (y), __FILE__, __LINE__)

static inline unsigned int
DDR_uncache_to_cache(unsigned int u_addr, char *file, int line)
{
#ifdef MEM_CHECK_ARG
        MEM_BUG(u_addr, file, line);
#endif
        return 0;
}

#endif 

#define	DDR_PHYADDR_TO_VADDR_UNCACHE(x)					\
        DDR_phyaddr_to_vaddr_uncache((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_phyaddr_to_vaddr_uncache(unsigned int p_addr, char *file, int line)
{
  unsigned int ch, offset;

  ch = DDR_phyaddr_to_ch(p_addr, file, line);
  offset = DDR_phyaddr_to_choffset(p_addr, file, line);

  if(ch){
    offset += DDR_CH1_OFFSET;
  }

  return DDR_vaddr_uncache(offset, file, line);
}

#define	DDR_VADDR_UNCACHE_TO_MEMOFFSET(x)				\
	DDR_vaddr_uncache_to_memoffset((unsigned int) (x), __FILE__, __LINE__)

static inline unsigned int
DDR_vaddr_uncache_to_memoffset(unsigned int addr, char *file, int line)
{
        unsigned int offset = 0;

#if 0 
        if (addr < DDR_CH0_MAPSTART) {
                MEM_BUG(addr, file, line);
        } else if (addr < DDR_CH0_MAPSTART+DDR_CH0_MAPSIZE) { 
                offset = addr - DDR_CH0_MAPSTART;
        } else if (addr < DDR_CH1_MAPSTART) {
                MEM_BUG(addr, file, line);
        } else if (addr < DDR_CH1_MAPSTART+DDR_CH1_MAPSIZE) { 
                offset = addr - DDR_CH1_MAPSTART;
        } else {
                MEM_BUG(addr, file, line);
        }
#else
        if ((DDR_CH0_MAPSTART <= addr) && (addr < (DDR_CH0_MAPSTART+DDR_CH0_MAPSIZE))) {            
                offset = addr - DDR_CH0_MAPSTART;
        } else if ((DDR_CH1_MAPSTART <= addr) && (addr < (DDR_CH1_MAPSTART+DDR_CH1_MAPSIZE))) {    
                offset = addr - DDR_CH1_MAPSTART;
        } else {
            MEM_BUG(offset, file, line);                 
        }

#endif
        return offset;
}


#endif
